/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GetBlockGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GetItemGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKobold
extends TameableCreatureEntity
implements IMob {
    public boolean griefing = true;
    public boolean theivery = true;
    private int torchLootingTime = 20;

    public EntityKobold(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = false;
        this.babySpawnChance = 0.1;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new GetItemGoal(this).setDistanceMax(8.0).setSpeed(1.2));
        if (this.griefing) {
            this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new GetBlockGoal(this).setDistanceMax(8).setSpeed(1.2).setBlockName("torch").setTamedLooting(false));
        }
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this));
    }

    @Override
    public void loadCreatureFlags() {
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
        this.theivery = this.creatureInfo.getFlag("theivery", this.theivery);
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        if (this.field_70128_L && !this.isTamed() && this.inventory.hasBagItems()) {
            this.inventory.dropInventory();
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.griefing && this.torchLootingTime-- <= 0) {
            this.torchLootingTime = 60;
            int distance = 2;
            String targetName = "torch";
            ArrayList possibleTargets = new ArrayList();
            for (int x = (int)this.field_70165_t - distance; x < (int)this.field_70165_t + distance; ++x) {
                block1: for (int y = (int)this.field_70163_u - distance; y < (int)this.field_70163_u + distance; ++y) {
                    for (int z = (int)this.field_70161_v - distance; z < (int)this.field_70161_v + distance; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block searchBlock = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (searchBlock == Blocks.field_150350_a) continue;
                        Object possibleTarget = null;
                        if (!ObjectLists.isName(searchBlock, targetName)) continue;
                        this.func_130014_f_().func_175655_b(pos, true);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public boolean shouldCreatureGroupRevenge(EntityLivingBase target) {
        if (target instanceof EntityPlayer && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return true;
        }
        return super.shouldCreatureGroupRevenge(target);
    }

    @Override
    public boolean shouldCreatureGroupHunt(EntityLivingBase target) {
        if (target instanceof EntityPlayer && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return true;
        }
        return super.shouldCreatureGroupHunt(target);
    }

    @Override
    public boolean shouldCreatureGroupFlee(EntityLivingBase target) {
        if (target instanceof EntityPlayer && target.func_110143_aJ() / target.func_110138_aP() <= 0.5f) {
            return false;
        }
        return super.shouldCreatureGroupFlee(target);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (!this.isTamed() && targetEntity.func_110143_aJ() / targetEntity.func_110138_aP() > 0.5f) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean canPickupItems() {
        return this.theivery;
    }
}

